#ifndef _LEVEL_
#define _LEVEL_
typedef enum TileType TileType;
typedef enum AudioFile AudioFile;
#include "common.h"
#include "game.h"
extern const int TS;
enum TileType {
    Platform,
    Root,
    Bush,
    Bee,
    GemDeep01 /* C */,
    GemDeep02,
    GemDeep03,
    GemDeep04,
    GemDeep05,
    GemDeep06,
    GemDeep07,
    GemDeep08,
    GemDeep09,
    GemDeep10,
    GemDeep11,
    GemDeep12,
    Ruby01,
    Ruby02,
    Beryl03,
    Beryl04,
    Citrine05,
    Emerald06,
    Carnelian07,
    Aquamarine08,
    Aquamarine09,
    Sapphire10,
    Opal11,
    Amethyst12,
    Diamond01,
    GemHigh02,
    GemHigh03,
    GemHigh04,
    GemHigh05,
    GemHigh06,
    GemHigh07,
    GemHigh08,
    GemHigh09,
    GemHigh10,
    GemHigh11,
    GemHigh12,
    Door,
    Heart,
    Board,
    Tile
};
enum AudioFile {
    Ding1Audio,
    Ding2Audio,
    Ding3Audio,
    Ding4Audio,
    Ding5Audio,
    Ding6Audio,
    Ding7Audio,
    Ding8Audio,
    Ding9Audio,
    Ding10Audio,
    Ding11Audio,
    Ding12Audio,
    Ding13Audio,
    Ding14Audio,
    Ding15Audio,
    Ding16Audio,
    Ding17Audio,
    Ding18Audio,
    Ding19Audio,
    Ding20Audio,
    Ding21Audio,
    Ding22Audio,
    Ding23Audio,
    Ding24Audio,
    Ding25Audio,
    Ding26Audio,
    Ding27Audio,
    Ding28Audio,
    Ding29Audio,
    Ding30Audio,
    Ding31Audio,
    Ding32Audio,
    Ding33Audio,
    Ding34Audio,
    Ding35Audio,
    Ding36Audio,
    JumpAudio,
    BiteAudio,
    FallAudio,
    BoredAudio,
    HeartAudio,
    DroppingAudio,
    DoorAudio,
    PoopAudio,
    DoorCloseAudio,
    FireballAudio,
    IcicleAudio,
    RootspellAudio,
    StarsAudio,
    AudioFileCount
};
extern int gemtable [];
LandSpriteType* get_tile(str name);
void put_tile(str name, int x, int y, TileType sid);
void put_animated(str name, int x, int y, int sid, float scale);
LandYaml* level_load(str n);
bool level_new(str num);
void level_place_from_yaml(LandYaml * yaml);
void level_place_background(void);
void load_sound(str name);
void stream_sound(str name);
void load_audio(void);
void play(AudioFile af, float vol, float pan, float speed);
#endif
